#include "CameraCBuffer.hlsli"

Texture2D RenderTargetTex : register(t0);
Texture2D<unorm float> DepthStencilTex : register(t1);

SamplerState PointSampler : register(s0);
SamplerState LinearSampler : register(s1);
SamplerState AnisoSampler : register(s2);

#include "Common.hlsli"
#include "Structures.hlsli"
#include "CameraEffects.hlsli"
#include "Tonemapping.hlsli"
#include "FilmGrain.hlsli"

float4 main(PSInput input) : SV_Target
{
	// The blurred image
	float4 result = Blur(input.TexCoords);
	
	result = ApplyTonemapping(result);
	
	// Add noise
	result += Noise(input.TexCoords);

	return result;
}